/**
 * @file ucprobe.h
 * @date 2017-06-26
 *
 * NOTE:
 * This file is generated by DAVE-4. Any manual modification done to this file will be lost when the code is regenerated.
 *
 * @cond
 ***********************************************************************************************************************
 * UCPROBE v4.0.4. Configures UCPROBE target code
 * Copyright (c) 2015-2017, Infineon Technologies AG
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the
 * following conditions are met:
 *
 *   Redistributions of source code must retain the above copyright notice, this list of conditions and the  following
 *   disclaimer.
 *
 *   Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the
 *   following disclaimer in the documentation and/or other materials provided with the distribution.
 *
 *   Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote
 *   products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT  OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * To improve the quality of the software, users are encouraged to share modifications, enhancements or bug fixes
 * with Infineon Technologies AG (dave@infineon.com).
 ***********************************************************************************************************************
 *
 * Change History
 * --------------
 *
 * 2016-07-30:
 *     - Initial version
 *
 * @endcond
 *
 */


#ifndef UCPROBE_H
#define UCPROBE_H

#include <stdint.h>
#include <DAVE_common.h>
#include "probe_scope.h"

#include "ucprobe_conf.h"

/**********************************************************************************************************************
* ENUMS
**********************************************************************************************************************/
 /**
  * @ingroup UCPROBE_enumerations
  * @{
  */

/**
 *   @brief The type identifies the APP status.
 */
typedef enum UCPROBE_STATUS
{
  /**
  * STATUS SUCCESS
  */
  UCPROBE_STATUS_SUCCESS = 0,

  /**
  * STATUS FAILURE
  */
  UCPROBE_STATUS_FAILURE,

} UCPROBE_STATUS_t;

/**
 * @}
 */
/**********************************************************************************************************************
* DATA STRUCTURES
**********************************************************************************************************************/
/**
  * @ingroup UCPROBE_datastructures
  * @{
  */


/**
 * @}
 */

/**
 * @ingroup UCPROBE_apidoc
 * @{
 */

/***********************************************************************************************************************
 * API Prototypes
 **********************************************************************************************************************/
/* Support for C++ */

#ifdef __cplusplus
extern "C" {
#endif
/**
 * @brief Retrieves the version of the UCPROBE APP.
 * @param None
 * @return DAVE_APP_VERSION_t APP version information (major, minor and patch number)
 *
 * \par<b>Description: </b><br>
 * The function can be used to check application software compatibility with a specific version of the APP.
 *
 *Example Usage:
 *
 * @code
  #include <DAVE.h>

  int main(void)
  {
    DAVE_APP_VERSION_t version;
    version = UCPROBE_GetAppVersion();
    while(1);
    return 0;
  }
 * @endcode
 */
DAVE_APP_VERSION_t UCPROBE_GetAppVersion(void);

/**
 * @brief Initializes the UCPROBE APP.
 * @param None
 * @return None
 *
 * \par<b>Description: </b><br>
 * Initializes the communication interface and Initializes the oscilloscope if enabled.
 *
 */
void UCPROBE_Init(void);

/**
 * @brief Sampling function when oscilloscope control support is enabled.
 * @param None
 * @return None
 *
 * \par<b>Description: </b><br>
 * This function must be called when your code needs to take a sample of all enabled channels.
 *
 */
void ProbeScope_Sampling(void);

/* Include App extern declaration file */
#include "ucprobe_extern.h"

/**
 * @}
 */
#ifdef __cplusplus
}
#endif
#endif /* UCPROBE_H */


